Attribute VB_Name = "modTask"
'Thanx to DevX.com's vb archives in general and Francesco Balena in particular
'for many of the functions used here

Option Explicit

' How to    delete/add/activate a taskbar item
'
' uses:     ole32, oleaut32, shdocvw
'
' infos:    http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/shell/reference/ifaces/itaskbarlist/itaskbarlist.asp
'

                                                                                
Private Const VarOffset As Long = 8
                                                                                ' (shlguid.h)
Private Const CLSID_TaskbarList = "{56FDF344-FD6D-11d0-958A-006097C9A090}"      ' clsid: => SHDOCVW.DLL
Private Const IID_ITaskbarList2 = "{602D4995-B13A-429b-A66E-1935E44F4317}"
                                                        '    vTable
Private Const IID_QueryInterface        As Long = 0     ' => QueryInterface(riid, @ppvObject) as HResult
Private Const IID_AddRef                As Long = 4     ' => AddRef() as ULong
Private Const IID_Release               As Long = 8     ' => Release() as ULong
Private Const IID_HrInit                As Long = 12    ' => HrInit() as HResult
Private Const IID_AddTab                As Long = 16    ' => AddTab(hWnd as Long) as HResult
Private Const IID_DeleteTab             As Long = 20    ' => DeleteTab(hWnd as Long) as HResult
Private Const IID_ActivateTab           As Long = 24    ' => ActivateTab(hWnd as Long) as HResult
Private Const IID_SetActiveAlt          As Long = 28    ' => SetActiveAlt(hWnd as Long) as HResult
Private Const IID_MarkFullscreenWindow  As Long = 32    ' => MarkFullscreenWindow(hWnd as Long, fFullscreen as boolean) as HResult

Private Const CLSCTX_INPROC_SERVER      As Long = 1     ' const: (WTYPES.h)   => ClassContext
Private Const CC_STDCALL                As Long = 4     ' const: (OAIDL.h)    => CallConvention
Private Const S_OK                      As Long = 0     ' const: (WINERROR.h)

Public Enum ITaskBarList
    AddItem = 16
    deleteitem = 20
    ActivateItem = 24
    MarkFullscreenWindow = 32
End Enum

Private Declare Function API_CLSIDFromString Lib "ole32" Alias "CLSIDFromString" (ByVal lpszProgID As Long, ByVal pCLSID As Long) As Long
Private Declare Function API_CoCreateInstance Lib "ole32" Alias "CoCreateInstance" (ByVal rclsid As String, ByVal pUnkOuter As Long, ByVal dwClsContext As Long, ByVal riid As String, ByRef ppv As Long) As Long
Private Declare Sub API_DispCallFunc Lib "oleaut32" Alias "DispCallFunc" (ByVal ppv As Long, ByVal oVft As Long, ByVal cc As Long, ByVal rtTYP As VbVarType, ByVal paCNT As Long, ByVal paTypes As Long, ByVal paValues As Long, ByRef fuReturn As Variant)
'ADDED BY BEIGE
Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long


' tskBAR        Add/Delete/Mark taskbar item
'
' CALL:         tskBAR(H1:hWnd, [C1:enmCommand], [F1:fFullscreen])
'
' IN:           lng:H1  Window to be deleted from list
'               enm:C1  Command (default = AddItem)
'               log:F1  Fullscreenmode (defined only with C1=MarkfullscreenWindow)
'
' OUT:          log     success
'
Public Function tskBAR(hWnd As Long, Optional enmCommand As ITaskBarList = AddItem, Optional fFullscreen As Boolean = True) As Boolean
    Dim oid     As String     ' object-id
    Dim iid     As String     ' interface-id
    Dim ipt     As Long       ' interface-ptr
    Dim ret     As Long
    Dim arT(1)  As Integer    ' parameter types
    Dim arV(1)  As Long       ' parameter values
    
    oid = cnvCLSID(CLSID_TaskbarList)
    iid = cnvCLSID(IID_ITaskbarList2)
    
    arT(0) = vbLong
    arT(1) = vbBoolean
    arV(0) = VarPtr(hWnd) - VarOffset
    arV(1) = VarPtr(fFullscreen) - VarOffset
    
    If API_CoCreateInstance(oid, 0&, CLSCTX_INPROC_SERVER, iid, ipt) = S_OK Then
        API_DispCallFunc ipt, IID_HrInit, CC_STDCALL, vbLong, 0&, 0&, 0&, ret
        API_DispCallFunc ipt, enmCommand, CC_STDCALL, vbLong, IIf(enmCommand = MarkFullscreenWindow, 2, 1), VarPtr(arT(0)), VarPtr(arV(0)), ret
        API_DispCallFunc ipt, IID_Release, CC_STDCALL, vbLong, 0, 0&, 0&, ret
        tskBAR = True
    End If
End Function

' cnvCLSID      Converts clsid-string to binary string (unicode)
'
' CALL:         cnvCLSID(clsid)
'
' IN:           chr:clsid   i.e. {3C374A40-BAE4-11CF-BF7D-00AA006946EE}
'
' OUT:          chr         16-byte converted string
'
Private Function cnvCLSID(clsid As String) As String
    Dim B1(15) As Byte
    
    API_CLSIDFromString StrPtr(clsid), VarPtr(B1(0))
    cnvCLSID = StrConv(B1, vbUnicode)
End Function


